#!/system/bin/sh
# Malez preconf
#
# 20100905 fix uid
#
LOCKDIR=/cache
READYPRECONF=${LOCKDIR}/preconf.ready
ACTION="exit 0"

if [ a$1 != "a" ]; then
	ACTION=$1
fi



fixApp () {
	APP=$1
	UID=$2
	END=0
	MAXTRY=30
	TRY=0
	while [ $END -eq 0 -a $TRY -le $MAXTRY ]; do
		NB=$(cat /data/system/packages.xml | egrep "^<package.*serId" | grep -v framework-res.apk | grep -v com.htc.resources.apk | grep -i $APP | wc -l)
		if [ $NB -ge 1 ]; then
			#cd /data/data && busybox unzip -o /system/etc/${APP}.zip && busybox chown -R ${UID}:${UID} /data/data/${APP} && busybox chmod -R 777 /data/data/${APP} && busybox chown -R 1000:1000 /data/data/${APP}/lib 			fix_permissions -f /system/app/${APP}.apk && END=1
			sleep 3s
			cd /data/data && busybox unzip -o /system/etc/${APP}.zip && busybox chown -R ${UID}:${UID} /data/data/${APP} \
			  && busybox chmod -R 777 /data/data/${APP} && busybox chown -R 1000:1000 /data/data/${APP}/lib \
			  && fix_permissions -f /system/app/${APP}.apk && END=1
		else
			echo "waiting for ${APP} to be installed"
			TRY=$(( $TRY + 1 ))

			sleep 5s
		fi
	done
	echo "${APP} preconf done"
}

if [ ! -d /data/data ]; then
	busybox mkdir /data/data
	busybox chown 1000:1000 /data/data/
	busybox chmod 771 /data/data/
fi

#for APP in com.fede.launcher org.adw.launcher; do
#	cd /data/data && busybox unzip -o /system/etc/${APP}.zip && fix_permissions -f /system/app/${APP}.apk
#done

fixApp com.fede.launcher 10054
fixApp org.adw.launcher 10063
fixApp jackpal.androidterm 10060
fixApp ws.plattner.cifsmanager 10064 

#fixApp com.android.providers.settings 1005
#Add Gscript database, scripts already added.
#fixApp nl.rogro.GScriptLite 10044


setUIval.sh usb_mass_storage_enabled 0 secure
#Activate debug
#fixApp com.android.settings 1000
setprop persist.service.adb.enable 1



#Add settings provider database entries
#setUIval.sh hearing_aid 1
setUIval.sh haptic_feedback_enabled 0
setUIval.sh ACER_UI 1
setUIval.sh transition_animation_scale 0.0
setUIval.sh window_animation_scale 0.0
setUIval.sh keypad_sensitivity 15
setUIval.sh touch_sensitivity 75

rm_runOnce preconf.sh


echo "Global preconf done"
echo "Touching $READYPRECONF"
touch $READYPRECONF
sync
$ACTION




