#!/system/bin/sh
#
# Malez @2010
# enable/disable/change ramzswap settings
# usage : ramzswap.sh ramzswapAmount sdSwapSize
# usage : ramzswap.sh 0 0 to disable
# usage : ramzswap.sh off to disable
# if swapSize=0, disable swap
#
# 20100820 added sdswap support + check size = 0 + check if numeric + NEED REBOOT TO APPLY
#20100904 no more default activation
#20100911 ramzswap module detection


SWAPFILE=/sdcard/swapfile
run(){

	#must wait for sdcard to be here
	SDMOUNTED=0
	while [ ${SDMOUNTED} -ne 1 ]; do
	  mount | grep sdcard && SDMOUNTED=1
	  sleep 2s
	done
            	
	ENABLE_RAMZSWAP=$(getUIval.sh LCR_RAMZSWAP_ON)
	SIZE_RAMZSWAP=$(getUIval.sh LCR_RAMZSWAP_SIZE)
	ENABLE_SDSWAP=$(getUIval.sh LCR_SDSWAP_ON)
	SIZE_SDSWAP=$(getUIval.sh LCR_SDSWAP_SIZE)

	echo "Read $ENABLE_RAMZSWAP $SIZE_RAMZSWAP $ENABLE_SDSWAP $SIZE_SDSWAP"
	
	#if properties are not set, activate
	if [ a${ENABLE_RAMZSWAP} = a ]; then
		echo "no value set for the moment"
		echo "set values first"
		exit 0
		#ENABLE_RAMZ=1
		#SIZE_RAMZ=51200
		#echo "default values : ramzswap = $SIZE_RAMZ"		
	fi

	#rawzwap
	if [ a${ENABLE_RAMZSWAP} = a1 -a a${SIZE_RAMZSWAP} != "a" -a a${SIZE_RAMZSWAP} != "a0" ];then
		
		echo "swapoff current ramzswap"
		swapoff /dev/block/ramzswap0 2>/dev/null 2>/dev/null
		rmmod ramzswap 2>/dev/null 2>/dev/null
		
		echo "load ramzwap module"
		#echo "insmod /modules/ramzswap.ko disksize_kb=${SIZE_RAMZSWAP}"
		if [ -f /modules/ramzswap.ko ]; then
		  MODULE=/modules/ramzswap.ko
		else 
		  MODULE=/system/modules/ramzswap.ko
		fi
		insmod $MODULE disksize_kb=${SIZE_RAMZSWAP}
		lsmod
		echo "swapon ramzswap"
		swapon /dev/block/ramzswap0 && "ramzswap enabled"
		
	#fi
	else #disable ramz

		echo "disable ramzswap"
		setUIval.sh LCR_RAMZSWAP_ON 0
		setUIval.sh LCR_RAMZSWAP_SIZE 0		
		swapoff /dev/block/ramzswap0 2>/dev/null
		rmmod ramzswap 2>/dev/null
		echo "ramzswap disabled"
	fi

	#sdwap
	if [ a${ENABLE_SDSWAP} = a1 -a a${SIZE_SDSWAP} != "a" -a a${SIZE_SDSWAP} != "a0" ] ;then
		
		if [ ! -f ${SWAPFILE} ]; then
			busybox swapoff ${SWAPFILE} && echo "done"
			echo "Creating Swapfile"
			dd if=/dev/zero of=${SWAPFILE} bs=1024 count=${SIZE_SDSWAP}
			echo "Swapfile created"
			echo "Preparing new swap file"
			busybox  mkswap ${SWAPFILE} && echo "Sd swap file prepared"
		fi
		
		busybox swapoff ${SWAPFILE}
		echo "Starting swap on SD"
		busybox swapon ${SWAPFILE} && echo "Sd swap enabled"
		
	#fi
	else #disable ram
		echo "disable sdswap"
		setUIval.sh LCR_SDSWAP_ON 0
		setUIval.sh LCR_SDSWAP_SIZE 0
		swapoff ${SWAPFILE} 2>/dev/null		
	fi

}

save(){
	
	if [ a$1 = a0 -o a$1 = aoff ]; then
		setUIval.sh LCR_RAMZSWAP_ON 0
	else
		setUIval.sh LCR_RAMZSWAP_ON 1
		setUIval.sh LCR_RAMZSWAP_SIZE $1
	fi
  	if [ a$2 = a0 -o a$2 = aoff -o a$2 = a ]; then
		setUIval.sh LCR_SDSWAP_ON 0
		swapoff ${SWAPFILE} 2>/dev/null && echo "Sd swap unmouted"
		rm -f ${SWAPFILE}
	else		
		setUIval.sh LCR_SDSWAP_ON 1
		setUIval.sh LCR_SDSWAP_SIZE $2		
		busybox swapoff ${SWAPFILE} 2>/dev/null && echo "Sd swap unmounted"
		echo "Creating Swapfile"
		dd if=/dev/zero of=${SWAPFILE} bs=1024 count=$2 
		echo "Swapfile created"
		echo "Preparing new swap file"
		busybox  mkswap ${SWAPFILE} && echo "Sd swap file prepared"

	fi
	ins_run ramzswap "ramzswap.sh"
	
	echo "Changes saved"
}

#check if a parameter was specified and is numeric

if [ a$1 == "astatus" ]; then
	ENABLE_RAMZ=$(getUIval.sh LCR_RAMZSWAP_ON)
	SIZE_RAMZ=$(getUIval.sh LCR_RAMZSWAP_SIZE)
	ENABLE_SDWAP=$(getUIval.sh LCR_SDSWAP_ON)
	SIZE_SDSWAP=$(getUIval.sh LCR_SDSWAP_SIZE)
	echo "Swap status Ramzswap : $(echo ${SIZE_RAMZ} | awk '{ printf ("%d",$1/1024) }') / SdSwap : $(echo ${SIZE_SDSWAP} | awk '{ printf ("%d",$1/1024) }')"
elif [ a$1 != "a" ]; then
	save $(echo $1 | awk '{ printf ("%d",$1*1024) }') $(echo $2 | awk '{ printf ("%d",$1*1024) }')
	run
else
	run
fi
echo
echo
free #| egrep -i "total|swap"




