#!/system/bin/sh
#
#
# Malez @2010
#
# Enable/Disable ads filtering
#
# 20100719 fix
# 20100821 change status
#

VERSION=1.2
MODE=status
CURRENT=/system/etc/hosts
ZIP=/system/etc/hosts.zip
TEMP=/data/local/tmp/
NOADS=${TEMP}/hosts.noads
STANDARD=${TEMP}/hosts.ori

usage (){
	echo "Usage"
	echo "$0 on/off/status"
	exit 1
}

error(){
	echo "Error : $1"
	exit 1
}

status (){

	MODE=Unknown	
	echo "=== Ads filtering status  ==="
	diff $CURRENT $NOADS >/dev/null 2>&1 && MODE=on
	diff $CURRENT $STANDARD >/dev/null 2>&1 && MODE=off
	
	echo "Ads filtering is $MODE"
	exit 0

}

if [ ! -s $STANDARD -o ! -s $NOADS ]; then
	cd $TEMP && unzip $ZIP
fi

for option in "$@"; do
    case $option in
         off)
            MODE="off"
         	
            ;;
         on)
            MODE="on"
         	   
             ;;

         status)
            MODE="status"
            
	    ;;

         -h | --help)
            usage
             ;;

          *)
            usage
            ;;
    esac
done

mount -o remount,rw /dev/block/mtdblock3 /system && echo "Done" || error "Unable to remount /system in rw mode"
if [ $MODE == "status" ]; then
	status
elif [ $MODE == "on" ]; then

	[ -s $NOADS ] && cat $NOADS > $CURRENT 

elif [ $MODE == "off" ]; then

	[ -s $STANDARD ] && cat $STANDARD > $CURRENT
fi



