#!/system/bin/sh
# 2010 malez
#
#
# Customize UI settings for LCR
#
# 20101214 added LCR_ONE and LCR_ZERO
# 201010 port for LCR-F
# file moved to /data/data/LCR_UI.txt

#CONF=/sdcard/LCR_UI.txt
CONF=/data/data/LCR_UI.txt
ACTION="exit 0"

readCustom() {
 	RES=$(grep ${1} $CONF | egrep -v '#' | cut -d '|' -f 3)
	[ -z $RES ] && RES=-1
	echo $RES
}


readCustomConf() {
	#mount | busybox grep sdcard || mount /sdcard 
	if [ -r $CONF ]; then
		echo "Custom conf file exists"
		ENABLED=$(readCustom THIS_CONF_MUST_BE_APPLIED	)

		RECOVERY=$(readCustom RECOVERY)
		if [ $RECOVERY -eq 1 ]; then
			echo "Recovery mode"
			#mount /dev/block/mmcblk0p1 /sdcard -t vfat -o remount,rw
			ENABLED=0
			
			if [ ! -s /data/system/packages.xml ]; then
			    echo "broken packages list"
			    if [ -s /data/system/packages.xml.bak ]; then
				echo "restoring .bak"  
				cat /data/system/packages.xml.bak > /data/system/packages.xml
			    else
				echo "restoring .bigbak"  
				cat /data/system/packages.xml.bigbak > /data/system/packages.xml.bak
			    fi
			fi

			mount /system -o remount,rw
			preconf.sh
			fix_permissions -r
			sed -i $CONF -e "s/|THIS_CONF_MUST_BE_APPLIED|1|/|THIS_CONF_MUST_BE_APPLIED|0|/g"
			sed -i $CONF -e "s/|RECOVERY|1|/|RECOVERY|0|/g"
			
			CHANGES=1
			
			ACER_UI=1
			LCR_LOCK=$ACER_UI
			LCR_MUSIC=$LCR_LOCK
			LCR_PHONE=$ACER_UI
			LCR_NOTIFICATION=$ACER_UI
			LCR_LAUNCHER=$ACER_UI
			LCR_DIALER=$ACER_UI	
	
			LCR_POWER_LOCK=$LCR_LOCK
			LCR_POWER=$LCR_LOCK
			LCR_CALENDAR=$ACER_UI
				
			
			sync
			rebootOnce
	    
		fi


		if [ a$ENABLED == a1 ]; then
			echo "Custom UI conf enabled, reading values"


			#first run backup
			if [ ! -e /data/system/packages.xml.bigbak ]; then
				cat /data/system/packages.xml > /data/system/packages.xml.bigbak
			fi
			    
			ACER_UI=1

		    

			#unlock all launchers
			UNLOCK_ALL_LAUNCHERS=$(readCustom UNLOCK_ALL_LAUNCHERS) 
			if [ $UNLOCK_ALL_LAUNCHERS -eq 1 ]; then
			      LCR_ALL_LAUNCHERS=1
			      cd /data/system/ && cat packages.xml > packages.xml.bak \
				      && grep -v '<item name="com.android.launcher2.Launcher"' packages.xml \
				      | grep -v '<item name="com.acer.android.breeze.launcher.Shell" />' \
				      | grep -v '<item name="com.acer.android.breeze.launcher.personalization.Personalization" />' > packages2.xml \
				      && cat packages2.xml > packages.xml \
				      && echo done && sync || echo "UNABLE TO ENABLE all launchers"
#| grep -v '<item name="com.android.stk.StkLauncherActivity" />' > packages2.xml \
			
			else
			      LCR_ALL_LAUNCHERS=0
			fi
  
			#status bar
			STATUS_BAR_AT_THE_BOTTOM=$(readCustom STATUS_BAR_AT_THE_BOTTOM) 
			if [ $STATUS_BAR_AT_THE_BOTTOM -eq 1 ]; then
				LCR_PHONE=0
			else
				LCR_PHONE=1
			fi
			
			#notification
			NOTIFICATION_TYPE_STREAM=$(readCustom NOTIFICATION_TYPE_STREAM) 
			if [ $NOTIFICATION_TYPE_STREAM -eq 1 ]; then
				ACER_UI=0
				#position
				STREAM_NOTIFICATION_ON_TOP=$(readCustom STREAM_NOTIFICATION_ON_TOP) 
				if [ $STREAM_NOTIFICATION_ON_TOP -eq 1 ]; then
					LCR_NOTIFICATION=1
				else	
					LCR_NOTIFICATION=0
				fi				
			#else
				#ACER_UI=1
			fi
						
			#dialer
			DIALER_TYPE_STREAM=$(readCustom DIALER_TYPE_STREAM) 
			if [ $DIALER_TYPE_STREAM -eq 1 ]; then
				LCR_DIALER=0			
			else
				LCR_DIALER=1
			fi
			
			DIALER_TYPE_AOSP=$(readCustom DIALER_TYPE_AOSP) 
			if [ $DIALER_TYPE_AOSP -eq 1 ]; then
				LCR_DIALER=1
				LCR_DIALER_TYPE_AOSP=1			
			else
				
				LCR_DIALER_TYPE_AOSP=0
			fi


			
			#launcher
			LAUNCHER_TYPE_STREAM=$(readCustom LAUNCHER_TYPE_STREAM) 
			if [ $LAUNCHER_TYPE_STREAM -eq 1 ]; then
				ACER_UI=0
				LCR_LAUNCHER=0		  
			else
				#ACER_UI=1
				LCR_LAUNCHER=1
			fi
				
			#lock
			LOCK_TYPE_STREAM=$(readCustom LOCK_TYPE_STREAM) 
			if [ $LOCK_TYPE_STREAM -eq 1 ]; then
				LCR_LOCK=0		
							
				#ACER_UI=0
				LCR_POWER_LOCK=0
				LCR_POWER=0
				LCR_CALENDAR=0
				LCR_MUSIC=0
				
			else
				#ACER_UI=1
				LCR_LOCK=1
				
				LCR_POWER_LOCK=1
				LCR_POWER=1
				LCR_CALENDAR=1
				LCR_MUSIC=1
			fi

			FULL_UI_ACER=$(readCustom FULL_UI_ACER)
			if [ $FULL_UI_ACER -eq 1 ]; then
				echo "Full UI acer"
				ACER_UI=0
				LCR_LOCK=$ACER_UI
				LCR_MUSIC=$ACER_UI
				LCR_PHONE=$ACER_UI
				LCR_NOTIFICATION=$ACER_UI
				LCR_LAUNCHER=$ACER_UI
				LCR_DIALER=$ACER_UI
				LCR_POWER_LOCK=$LCR_LOCK
				LCR_POWER=$LCR_LOCK
				LCR_CALENDAR=$ACER_UI	
				
			fi
			
			FULL_UI_ANDROID=$(readCustom FULL_UI_ANDROID)
			if [ $FULL_UI_ANDROID -eq 1 ]; then
				echo "Full UI android"
				ACER_UI=1	
				LCR_LOCK=$ACER_UI
				LCR_MUSIC=$ACER_UI
				LCR_PHONE=$ACER_UI
				LCR_NOTIFICATION=$ACER_UI
				LCR_LAUNCHER=$ACER_UI
				LCR_DIALER=$ACER_UI
				LCR_POWER_LOCK=$LCR_LOCK
				LCR_POWER=$LCR_LOCK
				LCR_CALENDAR=$ACER_UI										
			fi
			
			
		else
			echo "Custom UI conf disableFiled"
			ACER_UI=1	
			LCR_LOCK=$ACER_UI
			LCR_MUSIC=$ACER_UI
			LCR_PHONE=$ACER_UI
			LCR_NOTIFICATION=$ACER_UI
			LCR_LAUNCHER=$ACER_UI
			LCR_DIALER=$ACER_UI
			LCR_POWER_LOCK=$LCR_LOCK
			LCR_POWER=$LCR_LOCK
			LCR_CALENDAR=$ACER_UI

		fi
	else
		echo "Custom conf file $CONF does not exist"
	fi

}

fixUI (){

	CHANGES=0

	#by default all android default UI
	ACER_UI=1;
	
	sqlite3 /data/data/com.android.providers.settings/databases/settings.db "select * from system where name='ACER_UI' and value='0' ;" | grep ACER_UI && ACER_UI=0
	LCR_LOCK=$ACER_UI
	
	LCR_PHONE=$ACER_UI
	LCR_NOTIFICATION=$ACER_UI
	
	LCR_LAUNCHER=$ACER_UI
	LCR_DIALER=$ACER_UI
	LCR_DIALER_TYPE_AOSP=0

	LCR_POWER_LOCK=$LCR_LOCK
	LCR_POWER=$LCR_LOCK
	LCR_CALENDAR=$ACER_UI
	LCR_MUSIC=$LCR_LOCK

	LCR_ALL_LAUNCHERS=0

	#customized conf
	readCustomConf

	#permanent rules
	LCR_MUSIC=$LCR_LOCK
	

	#enable / disabe apks
	checkFile
	

	#checkCurrent val
	[ $(getUIval.sh ACER_UI)  -eq $ACER_UI ] || CHANGES=1
	[ $(getUIval.sh LCR_LOCK ) -eq $LCR_LOCK ] || CHANGES=1
	[ $(getUIval.sh LCR_PHONE) -eq $LCR_PHONE ] || CHANGES=1
	[ $(getUIval.sh LCR_NOTIFICATION ) -eq $LCR_NOTIFICATION ] || CHANGES=1
	[ $(getUIval.sh LCR_POWER_LOCK ) -eq $LCR_POWER_LOCK ] || CHANGES=1
	[ $(getUIval.sh LCR_CALENDAR ) -eq $LCR_CALENDAR ] || CHANGES=1
	[ $(getUIval.sh LCR_MUSIC ) -eq $LCR_MUSIC ] || CHANGES=1
	[ $(getUIval.sh LCR_LAUNCHER ) -eq $LCR_LAUNCHER ] || CHANGES=1
	[ $(getUIval.sh LCR_DIALER ) -eq $LCR_DIALER ] || CHANGES=1
	[ $(getUIval.sh LCR_ALL_LAUNCHERS ) -eq $LCR_ALL_LAUNCHERS ] || CHANGES=1
	[ $(getUIval.sh LCR_DIALER_TYPE_AOSP ) -eq $LCR_DIALER_TYPE_AOSP ] || CHANGES=1

	[ $(getUIval.sh LCR_ONE ) -eq 1 ] || setUIval.sh LCR_ONE 1
	[ $(getUIval.sh LCR_ZERO ) -eq 0 ] || setUIval.sh LCR_ZERO $LCR_ONE 1

	
	#if changes where made
	if [ $CHANGES -eq 1 ]; then
		echo "Changes where made to configuration"
		setUIval.sh ACER_UI $ACER_UI
		setUIval.sh LCR_LOCK $LCR_LOCK
		setUIval.sh LCR_PHONE $LCR_PHONE
		setUIval.sh LCR_NOTIFICATION $LCR_NOTIFICATION
		setUIval.sh LCR_POWER_LOCK $LCR_POWER_LOCK
		setUIval.sh LCR_POWER $LCR_POWER
		setUIval.sh LCR_CALENDAR $LCR_CALENDAR
		setUIval.sh LCR_MUSIC $LCR_MUSIC
		setUIval.sh LCR_LAUNCHER $LCR_LAUNCHER
		setUIval.sh LCR_DIALER $LCR_DIALER
 		setUIval.sh LCR_ALL_LAUNCHERS $LCR_ALL_LAUNCHERS
		setUIval.sh LCR_DIALER_TYPE_AOSP $LCR_DIALER_TYPE_AOSP
		
		
		
		#echo "Changes were applied"
		MODIFIED=1
	else
		MODIFIED=0
		#echo "No UI changes to apply"
	fi
	getUIval.sh LCR_ALL
	
}

enableFile () {
  BAK=/system/bak
  APP=/system/app
  RET=0

  [ ! -d ${BAK} ] && mkdir ${BAK}
  for f in $*; do
	  if [ ! -s ${APP}/$f ]; then
      		echo "$f need to be enabled"
		if [ -s ${BAK}/$f ]; then
      			#cat ${BAK}/$f > ${APP}/$f && rm -f ${BAK}/$f && echo "$f enabled" || echo "Unable to enable $"
      			mv -f ${BAK}/$f ${APP}/$f &&  echo "$f enabled" || (echo "Unable to enable $f"; RET=1)
		else
			echo "$f can't be restored : NO BACKUP FOUND"
			RET=1
		fi
	else # file already enable
        	echo "$f is already enabled"
		rm -f ${BAK}/$f
 	fi
  done
  return $RET
}

disableFile () {
  BAK=/system/bak
  APP=/system/app
  RET=0

  [ ! -d ${BAK} ] && mkdir ${BAK}
	
  for f in $*; do
	if [ -e ${APP}/$f ]; then
      		echo "$f need to be disabled"
		if [ ! -s ${BAK}/$f ]; then
      			#cat ${BAK}/$f > ${APP}/$f && rm -f ${BAK}/$f && echo "$f enabled" || echo "Unable to enable $"
      			mv -f ${APP}/$f ${BAK}/$f &&  echo "$f disabled" || (echo "Unable to disable $f"; RET=1)
		else
			rm -f ${APP}/$f &&  echo "$f already backed up and removed" || (echo "Unable to disable $f"; RET=1)
		fi
	else # file already enable
        	echo "$f is already disabled"
 	fi
  done
  return $RET

}


checkFile() {

	echo "entering checkFile"
	###### mount in rw
	#mount /dev/block/mtdblock3 /system -o remount,rw || echo "Oups Unable to mount system in rw"

	busybox mount -o remount,rw /dev/block/mtdblock3 /system || echo "Oups Unale to mount system in ro"

	ALLFILES="AcerLauncher.apk BubbleNotification.apk WidgetOverlay.apk PowerControl.apk PowerControlOnLock.apk Phone.apk"
	NEEDREBOOT=0
	
	if [ a$ENABLED == a1 -a a$FULL_UI_ANDROID != a1 ]; then		
		echo "enabling acer shell"
		grep acer.shell.mode=DISABLED /system/build.prop && echo "shell change" && sed -i -e "s/acer.shell.mode=DISABLED/acer.shell.mode=ENABLED/g" /system/build.prop && echo reboot && NEEDREBOOT=1
		grep acer.shell.contacts.mode=DISABLED /system/build.prop && echo "contacts change" && sed -i -e "s/acer.shell.contacts.mode=DISABLED/acer.shell.contacts.mode=ENABLED/g" /system/build.prop && echo reboot && NEEDREBOOT=1
	else #conf is disabled
		echo "disabling acer shell"
		grep acer.shell.mode=ENABLED /system/build.prop && echo "shell change" && sed -i -e "s/acer.shell.mode=ENABLED/acer.shell.mode=DISABLED/g" /system/build.prop && echo reboot && NEEDREBOOT=1
		grep acer.shell.contacts.mode=ENABLED /system/build.prop && echo "contacts change" && sed -i -e "s/acer.shell.contacts.mode=ENABLED/acer.shell.contacts.mode=DISABLED/g" /system/build.prop && echo reboot && NEEDREBOOT=1
		
	fi

	if [ $NEEDREBOOT -eq 1 ]; then
	  echo "reboot needed"
	  
	  #reboot
	fi

	if [ $ACER_UI -eq 0 ]; then
	    enableFile AcerLauncher.apk
	    enableFile BubbleNotification.apk 
	else
	    disableFile AcerLauncher.apk
	    disableFile BubbleNotification.apk
	fi


	if [ $LCR_LOCK -eq 0  ] ; then
		enableFile WidgetOverlay.apk      

		#enable acer widget
		cd /data/system/ && cat packages.xml > packages.xml.bak \
			&& grep -v '<item name=\"com.acer.android.breeze.widgetscreen.WidgetScreen\"' packages.xml  > packages2.xml \
			&& cat packages2.xml > packages.xml \
			&& echo done && sync || echo "UNABLE TO ENABLE com.acer.android.breeze.widgetscreen.WidgetScreen"
			
		#MUSIC
		diff /system/etc/apks/MusicAcer.apk /system/app/Music.apk || cp -f /system/etc/apks/MusicAcer.apk /system/app/Music.apk
	else
		#disableFile acer widget
		echo "need to disableFile AcerWidget"
		disableFile WidgetOverlay.apk
		
		#MUSIC
		diff /system/etc/apks/MusicMod.apk /system/app/Music.apk || cp -f /system/etc/apks/MusicMod.apk /system/app/Music.apk	
				
	fi
	
	

	#if [ $LCR_POWER -eq 0 ]; then
	#   enableFile PowerControl.apk
	#else
	#    disableFile PowerControl.apk
	#fi

	#if [ $LCR_POWER_LOCK -eq 0 ]; then
	    #enableFile PowerControlOnLock.apk
	#else
	    #disableFile PowerControlOnLock.apk
	#fi

	if [ $LCR_DIALER -eq 1 ] ; then
	    #enableFile Phone.apk 
	    	#&& (sed -i -e 's!codePath="/system/app/ShellPhone.apk"!codePath="/system/app/Phone.apk"!g' /data/system/packages.xml ; \
		#disableFile AcerPhone.apk ; \
		#disableFile ShellPhone.apk )
	    #sed -i -e s§codePath="/system/app/AcerContacts.apk"$codePath="/system/app/Contacts.apk"§g /data/system/packages.xml
	    touch /data/data/ACER_UI && chown 1000.1000 /data/data/ACER_UI && chmod 600 /data/data/ACER_UI	
	else	
	    #disableFile Phone.apk
	    #enableFile AcerPhone.apk
	    #enableFile ShellPhone.apk \
	    #	&& sed -i -e 's!codePath="/system/app/Phone.apk"!codePath="/system/app/ShellPhone.apk"!g' /data/system/packages.xml
	    #sed -i -e s§codePath="/system/app/Contacts.apk"$codePath="/system/app/AcerContacts.apk"§g /data/system/packages.xml
	    rm -f /data/data/ACER_UI 
	fi

	#if [ $LCR_DIALER_TYPE_AOSP -eq 1 ]; then
	#    echo "enabling aosp dialer"
	#    if [ ! -s /system/bak/AcerContacts.apk ]; then
	#	echo "backing up AcerContacts.apk"
	#	mkdir /system/bak/ 
	#	cat /system/app/AcerContacts.apk > /system/bak/AcerContacts.apk || echo "Unable to backup Acer Contacts"
	#    fi
	#    #change acerContacts if needed to aosp
	#    if [ -s /system/bak/AcerContacts.apk ]; then
	#	cat /system/app/Contacts.apk > /system/app/AcerContacts.apk || echo "Unable to replace Acer Dialer by AOSP"
	#    else	
	#	echo "Acer Contacts was not well backed up, AOSP will not be enabled"
	#    fi

	#else
	    #restore original if needed
	#    if [ -s /system/bak/AcerContacts.apk ] ; then
	#      diff /system/app/AcerContacts.apk /system/bak/AcerContacts.apk || ( echo "restoring original contacts"; cat /system/bak/AcerContacts.apk > /system/app/AcerContacts.apk)
	#    fi
	#fi

	
	if [ $LCR_LAUNCHER -eq 1 ]; then
	  #enableFile Launcher2.apk 
	  disableFile AcerLauncher.apk
	else
	  #disableFile Launcher2.apk 
	  enableFile AcerLauncher.apk
	fi
	  cd /data/system/ && cat packages.xml > packages.xml.bak \
	    && grep -v '<item name="com.android.launcher2.Launcher"' packages.xml \
	    | grep -v '<item name="com.acer.android.breeze.launcher.Shell" />' \
	    | grep -v '<item name="com.acer.android.breeze.launcher.personalization.Personalization" />' > packages2.xml \
	    && cat packages2.xml > packages.xml \
	    && echo done && sync || echo "UNABLE TO ENABLE all launchers"
	

	if [ $LCR_ALL_LAUNCHERS -eq 1 ]; then
	  enableFile Launcher.apk 
	  enableFile AcerLauncher.apk
	  cd /data/system/ && cat packages.xml > packages.xml.bak \
	    && grep -v '<item name="com.android.launcher2.Launcher"' packages.xml \
	    | grep -v '<item name="com.acer.android.breeze.launcher.Shell" />' \
	    | grep -v '<item name="com.acer.android.breeze.launcher.personalization.Personalization" />' > packages2.xml \
	    && cat packages2.xml > packages.xml \
	    && echo done && sync || echo "UNABLE TO ENABLE all launchers"
	fi

	

	#mount /dev/block/mtdblock3 /system -o remount,ro || echo "Oups Unale to mount system in ro"
	busybox mount -o remount,ro /dev/block/mtdblock3 /system || echo "Oups Unale to mount system in ro"

}
##########################
#
# MAIN
#
##########################


if [ a$1 != "a" ]; then
	ACTION=$1
fi

END=0
date
while [ $END -ne 1 ]; do
	if [ -e /data/data/com.android.providers.settings/databases/settings.db ]; then
		sleep 2s
		#ALREADYMOUNTED=0
		#mount | grep sdcard && ALREADYMOUNTED=1 && echo "sd mounted by vold" || (echo "manual mount";mount /dev/block/mmcblk0p1 /sdcard -t vfat -o ro,dirsync,nosuid,nodev,noexec,uid=1000,gid=1000)
		fixUI
		sync
		#if [ $ALREADYMOUNTED -eq 0 ]; then
		#  mount | grep sdcard | grep vold || (sync; umount /sdcard || echo "Really unable to umount SDCARD")
#|| sleep 5s ; umount /sdcard || sleep 5s ; umount /sdcard || echo "Really unable to umount SDCARD"
		#fi
		END=1
	else
		sleep 15s
	fi
	
done

#killall vold

if [ $MODIFIED -eq 1 -o $NEEDREBOOT -eq 1 ]; then
  if [ ! -e /cache/checkUIreboot1 ]; then
      touch /cache/checkUIreboot1
  else
    if [ ! -e /cache/checkUIreboot2 ]; then
	echo "SECOND REBOOT !!  WARNING"
	touch /cache/checkUIreboot2
    else
	echo "OUPS WE ARE IN A BOOTLOOP WHILE APPLYING CHANGES (THEY WE NOT KEPT)"
	echo "Disabling checkUI !" 
	echo "use ins_run checkUI.sh \"nohup checkUI.sh reboot >>cache/log/checkUI.log 2>&1 &\" to enable"
	fixUI.sh
	rm_run checkUI.sh
    fi
  fi
  echo "Changes were applied"
  if [ $NEEDREBOOT -eq 1 ]; then
    echo "Immediate reboot required for system props"
    reboot
  fi
  echo "Processing ${ACTION}"
  $ACTION
else
  echo "No UI changes to apply"
  rm -f /cache/checkUIreboot 2>/dev/null
  rm -f /cache/checkUIreboot2 2>/dev/null
fi
sync




