#!/system/bin/sh
#
#
# Malez @2010
#
# Backup/Restore SMS
#
VERSION=1
BACKUPBASE=/sdcard/backup/
BACKUPDIR=$BACKUPBASE/mmssms/
BACKUPFILE=$BACKUPDIR/mmssms.db
ORIDIR=/data/data/com.android.providers.telephony/databases/
ORIFILE=$ORIDIR/mmssms.db

usage (){
	echo "Usage"
	echo "$0 backup/restore/purge"
	exit 1
}

error(){
	echo "Error : $1"
	exit 1
}


for option in "$@"; do
    case $option in
         backup)
            MODE="backup"
         	
            ;;
         restore)
            MODE="restore"
         	   
             ;;

         purge)
            MODE="purge"
            
	    ;;

         -h | --help)
            usage
             ;;

          *)
            usage
            ;;
    esac
done

[ a$1 == a ] && usage

if [ $MODE == "backup" ]; then
	mkdir $BACKUPBASE 2>/dev/null
	mkdir $BACKUPDIR 2>/dev/null
	busybox cat $ORIFILE > $BACKUPFILE && echo "MMS backup done" && sync || echo "MMS backup failed"
elif [ $MODE == "restore" ]; then
	if [ -s $BACKUPFILE ]; then
		busybox cat $BACKUPFILE > $ORIFILE && echo "MMS Restoration done" && sync && reboot || echo "MMS restore failed"
	else
		echo "Unable to restore : No backup found"
	fi

elif [ $MODE == "purge" ]; then
	busybox rm -f $ORIFILE && echo "MMS purge done" && sync && reboot
fi



