#!/system/bin/sh
#
# Malez @2010
#
# purge apanic logs
#

usage() {
        echo "Usage"
        echo "$0 [days]" 
        exit 1


}

purge() {

	SRC=/sdcard/
	OLD=1
	if [ a$1 != a ]; then
		OLD=$1
	fi


	find $SRC -name "apanic*.txt" -exec gzip {} \; 
	if [ $OLD -eq 0 ]; then
		find $SRC -name "apanic*.txt.gz" -exec rm -f {} \; 
	else
		find $SRC -name "apanic*.txt.gz" -mtime +${OLD} -exec rm -f {} \; 
	fi	

}

#####
ERROR=0
END=0
RETRY=24 #240s

id | grep root || su
while [ $END -ne 1 -a $ERROR -lt $RETRY ]; do
	mount | grep /sdcard && END=1 || ERROR=$(( $ERROR + 1 ))
	if [ $END -eq 1 ]; then
		purge $1
	else
		sleep 10
	fi
done

