#!/system/bin/sh
#
#
# Malez @2010
#
# Enable/Disable High speed network
#
# 20100820 reboot switch
# 20121016 Fix switching, add more settings to toggle
VERSION=1
MODE=status

usage (){
	echo "Usage"
	echo "$0 standard/high/status"
	exit 1
}

error(){
	echo "Error : $1"
	exit 1
}

status (){

	echo "=== Network Status ==="
	grep ^ro.ril.hsxpa=1 /system/build.prop && MODE=standard
	grep ^ro.ril.hsxpa=2 /system/build.prop && MODE=high
	
	grep s/^ro.ril.gprsclass/ /system/build.prop
	echo "network mode is set to $MODE"
	exit 0

}


for option in "$1"; do
    case $option in
         standard)
            MODE="standard"
         	
            ;;
         high)
            MODE="high"
         	   
             ;;

         status)
            MODE="status"
            
	    ;;


      	-h | --help)
            usage
             ;;

          *)
            usage
            ;;
    esac
done

mount -o remount,rw /dev/block/mtdblock3 /system && echo "Done" || error "Unable to remount /system in rw mode"
if [ $MODE == "status" ]; then
	status
elif [ $MODE == "high" ]; then

    sed -i 's/ro.ril.hsxpa=1/ro.ril.hsxpa=2/g' /system/build.prop
    sed -i 's/ro.ril.gprsclass=10/ro.ril.gprsclass=12/g' /system/build.prop
    sed -i 's/^#ro.ril.hep=\(.*\)/ro.ril.hep=/1/g' /system/build.prop
    sed -i 's/^#ro.ril.hsdpa.category=\(.*\)/ro.ril.hsdpa.category=\1/g' /system/build.prop
    sed -i 's/^#ro.ril.enable.3g.prefix=\(.*\)/ro.ril.enable.3g.prefix=\1/g' /system/build.prop
    sed -i 's/^#ro.ril.htcmaskw1.bitmask=\(.*\)/ro.ril.htcmaskw1.bitmask=\1/g' /system/build.prop
    sed -i 's/^#ro.ril.htcmaskw1=\(.*\)/ro.ril.htcmaskw1=\1/g' /system/build.prop
    sed -i 's/^#ro.ril.hsupa.category=\(.*\)/ro.ril.hsupa.category=\1/g' /system/build.prop
	sync
    [ a$2 = "a" ] && reboot	  
elif [ $MODE == "standard" ]; then
    sed -i 's/ro.ril.hsxpa=2/ro.ril.hsxpa=1/g' /system/build.prop
    sed -i 's/ro.ril.gprsclass=12/ro.ril.gprsclass=10/g' /system/build.prop
    sed -i 's/^ro.ril.hep=\(.*\)/#ro.ril.hep=\1/g' /system/build.prop
    sed -i 's/^ro.ril.hsdpa.category=\(.*\)/#ro.ril.hsdpa.category=\1/g' /system/build.prop
    sed -i 's/^ro.ril.enable.3g.prefix=\(.*\)/#ro.ril.enable.3g.prefix=\1/g' /system/build.prop
    sed -i 's/^ro.ril.htcmaskw1.bitmask=\(.*\)/#ro.ril.htcmaskw1.bitmask=\1/g' /system/build.prop
    sed -i 's/^ro.ril.htcmaskw1=\(.*\)/#ro.ril.htcmaskw1=\1/g' /system/build.prop
    sed -i 's/^ro.ril.hsupa.category=\(.*\)/#ro.ril.hsupa.category=\1/g' /system/build.prop
	sync
    [ a$2 = "a" ] && reboot	       	
fi



