#!/system/bin/sh
# 2010 malez (full rewrite)
# 
# fix UI settings to full android
#
# 20100629 enable / disable file
# 20101028 lcr-F + Music
enableFile () {
  BAK=/system/bak
  APP=/system/app
  RET=0

  [ ! -d ${BAK} ] && mkdir ${BAK}
  for f in $*; do
	  if [ ! -s ${APP}/$f ]; then
      		echo "$f need to be enabled"
		if [ -s ${BAK}/$f ]; then
      			#cat ${BAK}/$f > ${APP}/$f && rm -f ${BAK}/$f && echo "$f enabled" || echo "Unable to enable $"
      			mv -f ${BAK}/$f ${APP}/$f &&  echo "$f enabled" || (echo "Unable to enable $f"; RET=1)
		else
			echo "$f can't be restored : NO BACKUP FOUND"
			RET=1
		fi
	else # file already enable
        	echo "$f is already enabled"
		rm -f ${BAK}/$f
 	fi
  done
  return $RET
}

disableFile () {
  BAK=/system/bak
  APP=/system/app
  RET=0

  [ ! -d ${BAK} ] && mkdir ${BAK}
	
  for f in $*; do
	if [ -e ${APP}/$f ]; then
      		echo "$f need to be disabled"
		if [ ! -s ${BAK}/$f ]; then
      			#cat ${BAK}/$f > ${APP}/$f && rm -f ${BAK}/$f && echo "$f enabled" || echo "Unable to enable $"
      			mv -f ${APP}/$f ${BAK}/$f &&  echo "$f disabled" || (echo "Unable to disable $f"; RET=1)
		else
			rm -f ${APP}/$f &&  echo "$f already backed up and removed" || (echo "Unable to disable $f"; RET=1)
		fi
	else # file already enable
        	echo "$f is already disabled"
 	fi
  done
  return $RET

}





LOCKDIR=/cache
READYUI=${LOCKDIR}/ui.ready
ACTION="exit 0"

if [ a$1 != "a" ]; then
	ACTION=$1
fi

RETRY=12
ERROR=0
END=0
NOTSET=0

mount /system -o remount,rw || echo "UNABLE TO MOUNT SYSTEM IN RW"


echo "entering waiting loop"
while [ $END -ne 1 -a $ERROR -lt $RETRY ]; do
	if [ -f /data/data/com.android.providers.settings/databases/settings.db ]; then
		for prop in ACER_UI LCR_LOCK LCR_PHONE LCR_NOTIFICATION LCR_POWER_LOCK LCR_POWER LCR_CALENDAR LCR_MUSIC LCR_LAUNCHER; do
			setUIval.sh $prop 1	
		done
		setUIval.sh transition_animation_scale 1.0

		setUIval.sh LCR_DIALER_TYPE_AOSP 0

		touch /data/data/ACER_UI && chown 1000.1000 /data/data/ACER_UI && chmod 600 /data/data/ACER_UI
        #check	
		NOTSET=0
		for prop in ACER_UI LCR_LOCK LCR_PHONE LCR_NOTIFICATION LCR_POWER_LOCK LCR_POWER LCR_CALENDAR LCR_MUSIC LCR_LAUNCHER ; do
			NBRET=$(sqlite3 /data/data/com.android.providers.settings/databases/settings.db "select * from system where name='${prop}' and value='1' ;" | wc -l)                          
        	        if [ $NBRET -ne 1 ]; then
				echo "$prop not correctly set"
				NOTSET=1
			fi
		done
		#CHECK AOSP
		prop=LCR_DIALER_TYPE_AOSP
		NBRET=$(sqlite3 /data/data/com.android.providers.settings/databases/settings.db "select * from system where name='${prop}' and value='0' ;" | wc -l)                          
       	        if [ $NBRET -ne 1 ]; then
			echo "$prop not correctly set"
			NOTSET=1
		fi

		if [ $NOTSET -eq 0 -a -f /data/data/ACER_UI ]; then           
			echo "UI set to ANDROID"
		       	END=1
		else
			echo "ERROR processing $ERROR"
			ERROR=$(( $ERROR + 1 ))
		fi
	else
		echo "db not present"
	fi
	sleep 10s

done

enableFile Phone.apk && sed -i -e 's!codePath="/system/app/ShellPhone.apk"!codePath="/system/app/Phone.apk"!g' /data/system/packages.xml

#restore original if needed
if [ -s /system/bak/AcerContacts.apk ] ; then
	diff /system/app/AcerContacts.apk /system/bak/AcerContacts.apk || ( echo "restoring original contacts"; cat /system/bak/AcerContacts.apk > /system/app/AcerContacts.apk)
fi





if [ $END -eq 1 ]; then
	rm_runOnce fixUI.sh
	sync
	echo "FixUI done"
	echo "Touching $READYUI"
	touch $READYUI
	sync
	$ACTION
fi

exit 0

